// hello
// TODO: Add switches
// add image

Module.thisProgram = "giffer";
//Module.arguments = ["--update", "--read-comments"];
Module.noInitialRun = true;
Module.noExitRuntime = true;

var gifs = {};

var gifListEl;

var clearAllGifs = function() {
	
	for (var gif in gifs)
	{
		gifs[gif].destroy();
		delete gifs[gif];
	}
};

var GifBar = function(name) {
	this.name = name;
	this.newName = null;
	this.loopcount = null;
	gifs[this.name] = this;
	
	this.el = document.createElement("div");
	
	var titleEl = document.createElement("div");
	titleEl.className = "title";
	titleEl.textContent = this.name;
	this.el.appendChild(titleEl);
	
	
	var loopEl = document.createElement("span");
	loopEl.innerHTML = "Loops <s class=\"prevloops\"></s><span class=\"loops\">?</span> times";
	this.el.appendChild(loopEl);
	
	var statusEl = document.createElement("span");
	statusEl.className = "status";
	statusEl.textContent = "Pending...";	
	this.el.appendChild(statusEl);
	
	gifListEl.appendChild(this.el);
	
	/*var el = this.el
	
	var reader = new FileReader();
	reader.readAsDataURL(new Blob([FS.readFile(this.name).buffer]));
	
	reader.onload = function() {
		var img = document.createElement("img");
		img.src = reader.result;
		el.appendChild(img);
	}*/
};

GifBar.prototype.begin = function() {
	this.el.querySelector(".status").textContent = "";//"Working...";
};

GifBar.prototype.updateLoopcount = function(loopcount) {
	this.loopcount = loopcount;
	this.el.querySelector(".loops").textContent = 
		loopcount == 0 ? "infinite" : loopcount;
	this.el.querySelector(".status").textContent = "";
};

GifBar.prototype.newFile = function(newName, bytesSaved) {
	
	if (this.loopcount != 0)
	{
		this.el.querySelector(".prevloops").textContent = this.loopcount;
		// TODO: only on update
		this.el.querySelector(".loops").textContent = "infinite";
	}
	
	var statusEl = this.el.querySelector(".status");
	statusEl.textContent = "Done!";
	if (bytesSaved > 0)	{
		statusEl.textContent += " " + bytesSaved + " bytes removed."; 
	}
	
	var downloadEl = document.createElement("button");
	downloadEl.textContent = "Download";
	downloadEl.onclick = (function(n) { 
		return function() {
			downloadMEMFSFile(n, n);
		}
	})(newName);
	this.el.insertBefore(downloadEl, this.el.querySelector(".title"));
	this.newName = newName;
	
	/*var el = this.el;
	
	var reader = new FileReader();
	reader.readAsDataURL(new Blob([FS.readFile(newName).buffer]));
	
	reader.onload = function() {
		console.log('did it');
		el.querySelector("img").src = reader.result;
	};*/
};

GifBar.prototype.destroy = function() {
	// delete everything, including the files
	
	gifListEl.removeChild(this.el); //FIXME
	
	// TODO: This is hack. Maybe move to directory?
	FS.destroyNode(FS.root.contents[this.name]);
	if (this.newName) {
		FS.destroyNode(FS.root.contents[this.newName]);
	}
	
};

// thanks https://groups.google.com/forum/#!topic/emscripten-discuss/xnTzhcsMj4U
var downloadMEMFSFile = function(memoryFSname, localFSname)
{
	var data = FS.readFile(memoryFSname);
	var blob;
	var isSafari = /^((?!chrome|android).)*safari/i.test(navigator.userAgent);
	if(isSafari) {
		blob = new Blob([data.buffer], {type: "application/octet-stream"});
	} else {
		blob = new Blob([data.buffer], {type: "application/octet-binary"});
	}
	// potential race condition here (maybe saveas.min.js isn't loaded yet)
	// but I assume the internet is faster than running this tool
	// and interacting with the UI
	saveAs(blob, localFSname);
}

var loadAndExec = function(evnt) {
	
	clearAllGifs();
	
	var files = evnt.srcElement.files;
	var filesLoaded = 0;
	var filesToLoad = files.length;
	
	//console.log(files);
	
	Module.arguments = [];
	
	var argEls = document.querySelectorAll("input[type=checkbox]");
	for (var i = 0; i < argEls.length; i++)
	{
		if (argEls[i].value && argEls[i].value[0] == '-' && argEls[i].checked)
		{
			Module.arguments.push(argEls[i].value);
		}
	}
	
	var check = function() {
		if (filesToLoad == filesLoaded && filesLoaded > 0)
		{
			Module.print(Module.thisProgram + " " + Module.arguments.join(" "));
			Module.callMain(Module.arguments);
		}
	};
	
	var loadFile = function(file) {
		
		//console.log(file);
		
		var reader = new FileReader();
		
		reader.onload = function() {
			//console.log(btoa(reader.result));
			//console.log(reader.result);
			
			var node = FS.createDataFile("./", file.name, reader.result, true, true, true);
			Module.arguments.push(file.name);
			//console.log(node);
			
			(new GifBar(file.name));
			
			filesLoaded++;
			check();
		};
		reader.onerror = function() {
			console.warn("Loading file", file.name, " failed!");
			filesToLoad--;
			check();
		};
		
		reader.readAsBinaryString(file);
	};
	
	for (var i = 0; i < files.length; i++) {
		
		loadFile(files[i]);
	}
	
};

var giffer_fileBegin = function(name) {
	gifs[name].begin();
	//console.log("begin: ", name);
};

var giffer_loopcount = function(name, loopcount) {
	gifs[name].updateLoopcount(loopcount);
	//console.log("loopcount: ", name, loopcount);
};

var giffer_fileDone = function(name, newName, bytesSaved) {
	
	gifs[name].newFile(newName, bytesSaved);
	
	// check thiscouldbebetter.neocities.org for the donwloading of 
	// files	
	//var blob = new Blob([FS.root.contents["tinytree_new.gif"].contents], {type: "image/gif"});
};

var inputFileChooserEl = document.createElement("input");
inputFileChooserEl.type = "file";
inputFileChooserEl.setAttribute("multiple", true);
inputFileChooserEl.addEventListener("change", loadAndExec);
document.body.appendChild(inputFileChooserEl);

var generateArgCheckbox = function(arg, displayname, description, checked) {
	
	checked = checked === undefined ? false : checked;
	
	var el = document.createElement("input");
	el.type = "checkbox";
	el.value = arg;
	el.title = description;
	el.checked = checked;
	// TODO: Is this behaviour we want?
	el.onchange = function(evnt) {
		// Rerun the entire thing (if there are gifs)
		
		//if (!evnt.srcElement.checked) {return;}
		
		var aretheregifs = false;
		for (var gif in gifs) {
			if (gifs.hasOwnProperty(gif)) {
				aretheregifs = true;
				break;
			}
		}
		
		if (aretheregifs) {
			// loadAndExec expects a callback with evnt and stuff,
			// it just uses the srcElement, so fake that here.
			loadAndExec({srcElement: inputFileChooserEl});
		}
	};
	document.body.appendChild(el);
	
	var descEl = document.createElement("span");
	descEl.textContent = displayname;
	descEl.title = description;
	document.body.appendChild(descEl);	
	
}

generateArgCheckbox("--read-comments", "Read comments", 
	"Read comments and display them in the console", true);
generateArgCheckbox("--update", "Update", 
	"If the gif doesn't loop forever, fix that", true);
generateArgCheckbox("--nuke", "Nuke", 
	"Remove all unnecessary comments & unknown headers, be careful with this, this destroys information that file archealogists like", false);

gifListEl = document.createElement("ol");
gifListEl.className = "giflist";
document.body.appendChild(gifListEl);

// Also display errors on the webpage
/*(function(){
	var prevPrintErr = Module.printErr;
	Module.printErr = function(text) {
		prevPrintErr(text);
		Module.print("ERROR: " + text);
	};
})();*/

Module.print("======= INSTRUCTIONS GIFFER WEBTOOL BETA =======");
Module.print("1: Select the switches below, hover over them to see their effect");
Module.print("2: Choose the GIFs you want to check/update");
Module.print("3: Download the updated GIFs! :)");
