#!/usr/bin/env python3
# -*- coding: utf-8 -*-


import requests, re, math, json, datetime, time
from neocities_api import Neocities


# why are there no constants in python lol
DAYS = 40 # 40 days log is the last log before some data gets filtered out
TARGET_DAYS = 90 # number of days the array should contain at maximum
SITENAME = "owlman" # site name to track
APIKEY = "nope" # site api key to upload to
SHOULDUPLOAD = False

DPATH = "js/" + SITENAME + "stattrack.json" # path to save & upload to


def createList(s):
    a = s.split(",")
    b = []
    for n in a:
        b.append(int(n))
    return b

def parseText(txt):
    # i am proud of this regex
    data = re.findall("data:\s\[([\d,]+)", txt)
    
    return {
        "days": DAYS,
        "time": datetime.datetime.utcnow().replace(tzinfo=datetime.timezone.utc).isoformat(),
        "info_api_call": doInfoRequest(),
        "hits": createList(data[0]),
        "views": createList(data[1])
    }
    
def mergeArr(oldArray, newArray):
    finalArr = []
    oldArr = list(reversed(oldArray))
    newArr = list(reversed(newArray))
    
    n = 0
    
    # assumes something is found, otherwise it'll just append the rest behind it
    for i in range(0, len(newArr)):
        if newArr[n] == oldArr[0]:
            fakeHit = False
            for j in range(1, len(newArr) - n):
                if newArr[n + j] != oldArr[j]:
                    fakeHit = True
            if fakeHit == False:
                break
        n += 1
            
    for i in range(0, n):
        finalArr.append(newArr[i])
    
    for i in range(0, min(len(oldArr), TARGET_DAYS - n)):
        finalArr.append(oldArr[i])
    
    return list(reversed(finalArr))
    
    
def mergeObj(oldObj, newObj):
    finalObj = newObj.copy()
    finalObj["hits"] = mergeArr(oldObj["hits"], newObj["hits"])
    finalObj["views"] = mergeArr(oldObj["views"], newObj["views"])
    finalObj["days"] = len(finalObj["views"])
    return finalObj

def clearOpenFile(f):
    f.seek(0) # set cursor to starting position
    f.truncate()
    
def process(txt):
    
    newObj = parseText(txt)
    
    f = open(DPATH, "r+")
    
    
    oldObjPresent = True
    
    
    try:
        oldObj = json.loads(f.read())
    except Exception as ex:
        print("Failed to load old object: {}".format(ex))
        oldObjPresent = False
    
    finalObj = None
    
    clearOpenFile(f)
    
    if oldObjPresent:
        finalObj = mergeObj(oldObj, newObj)
    else:
        finalObj = newObj
    
    f.write(json.dumps(finalObj))
    f.close()
    
    print(finalObj)
    
    print("succesfully wrote to file")
    

def doInfoRequest():
    neoapi = Neocities("jeff")
    return neoapi.info(SITENAME)

def upload():
    api = Neocities(APIKEY)
    
    try:
        api.upload((DPATH, DPATH))
        print("upload to neocities site succesful")
    except Neocities.InvalidRequest as e:
        print("failed to upload: invalid api key(probably)")
    except Exception as ex:
        print("something went wrong uploading? is the Neocities api offline, or are you offline? {}".format(ex))

def doit():
    
    r = requests.get("https://neocities.org/site/" + SITENAME + "/stats?days=" + str(DAYS))
    
    if r:
        print("got response")
    else:
        print("not found")
        return False
    
    time.sleep(3)
    
    process(r.text)
    
    if SHOULDUPLOAD:
        time.sleep(11)
        upload()

doit()

def test():
    f = open(DPATH, "r")
    oldObj = json.loads(f.read())
    f.close()
    
    f = open("js/" + SITENAME + "stattrack_new.json")
    newObj = json.loads(f.read())
    f.close()
    
    finalObj = mergeObj(oldObj, newObj)
    print(finalObj)
    
#test()
