#!/usr/bin/env python3
# -*- coding: utf-8 -*-

import requests

class Neocities:
	""" (incomplete and slightly messy) Neocities API implementation
	Be careful! Your site might get a penalty if you use too much API calls!
	"""

	def __init__(self, apikey, opts={}):
		self.auth_hdr = "Bearer {}".format(apikey)
		self.url = opts.get("url", "https://neocities.org")

	def info(self, sitename):
		""" Queries info for a Neocites site(authentication optional)"""
		return self._parseresult(requests.get(
			self._request_url("info"),
			params={"sitename": sitename}
		))

	def key(self):
		""" Returns the site's API key"""
		return self._parseresult(requests.get(
			self._request_url("key"),
			headers={"Authorization": self.auth_hdr}
		))

	def upload(self, *files):
		""" Upload files. files is a *tuple(name: string, path: string)
			name is the name on the server,
			path is the local file path. """
		return self._parseresult(requests.post(
			self._request_url("upload"),
			headers={"Authorization": self.auth_hdr},
			files={i[0]: open(i[1], "rb") for i in files}
		))

	def delete(self, *filenames):
		""" Delete files from the website.
			Filenames is a tuple of filenames to delete.
			BE CAREFUL WITH THIS! """
		return self._parseresult(requests.post(
			self._request_url("delete"),
			headers={"Authorization": self.auth_hdr},
			data={"filenames[]": [i for i in filenames]}
		))


	def _request_url(self, method):
		return "{}/api/{}".format(self.url, method)


	def _parseresult(self, resp):
		if resp.status_code == requests.codes.ok:
			return resp.json()
		elif resp.status_code == 403:
			raise self.NotAuthorized(resp)
		else:
			raise self.InvalidRequest(resp)

	""" TODO: Add 400(bad request) """
	class InvalidRequest(Exception):
		def __init__(self, resp):
			self.resp = resp

		def __str__(self):
			return "Request returned status code {}:{}".format(self.resp.status_code, self.resp.json())

	class NotAuthorized(InvalidRequest):
		""" Raised when the API key is invalid """

def main(args):
    return 0

if __name__ == '__main__':
    import sys
    sys.exit(main(sys.argv))
